/*
    MoveEx 1.0
    schedules a file rename operation to be done at the next reboot
    e.g. to replace files currently in use
    more or less just a wrapper around the MoveFileEx() API

    (C) 1998 by Alexander Frink (Alexander.Frink@Uni-Mainz.de)
    This is free software.
*/


#include <windows.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

int main(int argc, char *argv[])
{
    struct _stat buf;
    int result;

    if (argc!=3) {
        printf("\n"
               "Usage: %s oldfile newfile\n\n"
               "       Moves 'oldfile' to 'newfile' at next reboot.\n"
               "       Useful to replace files currently in use.\n"
               "       It works on Windows NT and local drives only!\n"
               "       On NTFS, SYSTEM must be granted 'Full Control' to the files in question!\n"
               "       There is no feedback (e.g. in the event log) stating error or success.\n\n"
               "       Examples:\n"
               "           %s test.txt test2.txt\n"
               "              renames test.txt in the current directory, overwrites test2.txt\n"
               "           %s test.txt c:\\temp\\test.txt\n"
               "              moves test.txt from the current directory to c:\\temp\n"
               "           %s test.txt c:\\temp\n"
               "              doesn't work, give the full path and file name for destination\n"
               "           %s c:\\test.txt d:\\test.txt\n"
               "              doesn't work, you can't move across different drives\n\n"
               "(C) 1998 by Alexander Frink (Alexander.Frink@Uni-Mainz.DE).\n"
               "This is free software.\n",argv[0],argv[0],argv[0],argv[0],argv[0]);
        return 1;
    }

    /* check if source file is accessible */
    result=_stat(argv[1],&buf);
    if (result==-1) {
        if (errno==2) {
            printf("File not found: %s.\n",argv[1]);
        } else {
            printf("Error accessing file %s: errno=%i.\n",argv[1],errno);
        }
        return 1;
    }

    /* check if destination file is not a directory (full path must be specified).
       existing files will be replaced */
    result=_stat(argv[2],&buf);
    if ((result==0)&&(buf.st_mode & _S_IFDIR)) {
        printf("Destination %s is a directory! Use path+name as 'newfile'!",argv[2]);
        return 1;
    }

    if (!MoveFileEx(argv[1],argv[2],MOVEFILE_DELAY_UNTIL_REBOOT|
                                    MOVEFILE_REPLACE_EXISTING)) {
        printf("Error moving %s to %s: %i.\n",argv[1],argv[2],GetLastError());
        return 1;
    }
    printf("%s will be moved to %s at next reboot.\n\n"
           "To undo this, start regedt32.exe and delete value PendingFileRenameOperations\n"
           "in key HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Control\\SessionManager.\n",
           argv[1],argv[2]);

    return 0;
}

